//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using Microsoft.Practices.EnterpriseLibrary.Configuration.Factory;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Injection
{
	/// <summary>
	/// Represents a generic factory to create objects.
	/// </summary>
	/// <typeparam name="T">The type of object to create.</typeparam>
    public class Factory<TObjectToCreate, TObjectConfiguration> : ObjectFactoryBase<TObjectToCreate, TObjectConfiguration>
        where TObjectToCreate : new()
	{
        public override TObjectToCreate Create(TObjectConfiguration unused, IConfigurationSource configurationSource)
		{
            return new TObjectToCreate();
		}
	}
}
